/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package demo.jdbc.visitor.tests;

import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.junit.Test;

import demo.jdbc.visitor.JdbcPreparedStatementVisitor;
import demo.jdbc.visitor.JdbcPreparedStatementVisitor.Expression;
import demo.jdbc.visitor.TestEdmProvider;

public class JdbcPreparedStatementVisitorTest {

  @Test
  public void test() throws Exception {
    transform("EmployeeId eq '1'");
  }

  @Test
  public void test2() throws Exception {
    transform("EmployeeId eq '1' and ManagerId eq '2'");
  }

  @Test
  public void test3() throws Exception {
    transform("EmployeeId eq '1' or (ManagerId eq '2' and TeamId eq '3')");
  }

  @Test
  public void test4() throws Exception {
    transform("EmployeeId eq 'maliciousCode' or (ManagerId eq '2' and TeamId eq '3')");
  }

  public void transform(final String rawExpression) throws Exception {

    TestEdmProvider provider = new TestEdmProvider();
    Edm edm = RuntimeDelegate.createEdm(provider);
    EdmEntityType entityType =
        edm.getEntityType(TestEdmProvider.NAMESPACE_1, TestEdmProvider.ENTITY_TYPE_1_1.getName());

    FilterExpression expression = UriParser.parseFilter(null, entityType, rawExpression);
    Expression exp = (Expression) expression.accept(new JdbcPreparedStatementVisitor());
    System.out.println("Raw: " + rawExpression + " ------> Whereclause: " + exp.toString());
    for (Object obj : exp.getParameters()) {
      System.out.println(obj.toString());
    }
  }
}
